<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class ComponenteTabella {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        private $intestazione;
        private $sfondoIntestazione;
        private $coloreTestiIntestazione;
        private $note;
        private $ordinabile;
        
        public function __construct($db, $id, $nome="", $spazioOccupato="", $intestazione="", $sfondoIntestazione = "", $coloreTestiIntestazione = "", $note="", $ordinabile="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->spazioOccupato          = $spazioOccupato;
            $this->intestazione            = $intestazione;
            $this->sfondoIntestazione      = $sfondoIntestazione;
            $this->coloreTestiIntestazione = $coloreTestiIntestazione;
            $this->note                    = $note;
            $this->ordinabile              = $ordinabile;
        }
        
        function crea() {
            $query    = "INSERT INTO geec_tabelle VALUES(NULL,'$this->nome','$this->spazioOccupato','$this->ordinabile','$this->intestazione','$this->sfondoIntestazione','$this->coloreTestiIntestazione','$this->note')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_tabelle SET nome='$this->nome', spazioOccupato='$this->spazioOccupato', intestazione='$this->intestazione', sfondoIntestazione = '$this->sfondoIntestazione', coloreTestiIntestazione='$this->coloreTestiIntestazione', note = '$this->note', ordinabile='$this->ordinabile' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_tabelle",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 29
            eliminaOccorrenzeComponente($this->db,$this->id,29);
        }
        
        function duplica() {
            $query    = "INSERT INTO geec_visualizzatoreProfili VALUES(NULL,'Copia di $this->nome')";
            $idNuovaForm = $this->db->eseguiQueryCreazione($query);
            
            $query       = "SELECT * FROM geec_righeTabella WHERE idTabella='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                $query = "INSERT INTO `geec_righeTabella` (`id`, `idTabella`, `posizione`, `nome`, `etichetta`, `valore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) "
                    . "VALUES (NULL, '$idNuovaForm', '{$elementoDaCopiare["posizione"]}', '{$elementoDaCopiare["nome"]}', '{$elementoDaCopiare["etichetta"]}', '{$elementoDaCopiare["valore"]}', '{$elementoDaCopiare["placeholder"]}', '{$elementoDaCopiare["tipo"]}', '{$elementoDaCopiare["opzioni"]}', '{$elementoDaCopiare["obbligatorio"]}')";
                $this->db->eseguiQueryCreazione($query);
            }
            return $idNuovaForm;
        }
        
        function caricaDatiDalDatabase() {
            $datiTabella    = $this->db->leggiSingolaRiga("geec_tabelle",$this->id);
            $this->nome     = $datiTabella["nome"];
            $this->spazioOccupato          = $datiTabella["spazioOccupato"];
            $this->intestazione            = $datiTabella["intestazione"];
            $this->sfondoIntestazione      = $datiTabella["sfondoIntestazione"];
            $this->coloreTestiIntestazione = $datiTabella["coloreTestiIntestazione"];
            $this->note                    = $datiTabella["note"];
            $this->ordinabile              = $datiTabella["ordinabile"];
        }
        
        function creaElemento($elementi,$coloreSfondo,$coloreTesti) {
            $queryPosizione = "SELECT * FROM geec_righeTabella WHERE idTabella=$this->id ORDER BY posizione DESC LIMIT 1";
            $risPosizione   = $this->db->eseguiQueryLettura($queryPosizione);
            $datiElemento   = $risPosizione->fetch_assoc();
            $posizione = ($risPosizione->num_rows>0) ? $datiElemento["posizione"] + 1 : 1;
            
            $query = "INSERT INTO `geec_righeTabella` (`id`, `idTabella`, `posizione`, `elementi`, `coloreSfondo`, `coloreTesti`) "
                    . "VALUES (NULL, '$this->id', '$posizione', '$elementi', '$coloreSfondo', '$coloreTesti')";
            $idElemento = $this->db->eseguiQueryCreazione($query);
            return $idElemento;
        }
        
        function stampaElementi() {
            $query = "SELECT * FROM geec_righeTabella WHERE idTabella = {$this->id} ORDER BY posizione ASC";
            $risultatoQuery = $this->db->eseguiQueryLettura($query);
            while($elemento = $risultatoQuery->fetch_assoc()) {
                $elementiEscape      = filter_var($elemento["elementi"],FILTER_SANITIZE_ADD_SLASHES);
                $posizionePrecedente = ($elemento["posizione"]<=1) ? 1 : $elemento["posizione"] - 1;
                $posizioneSuccesiva  = $elemento["posizione"] +1;
            ?>
                <div id="elementoComponente<?php echo $elemento["id"] ?>" class="card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center">
                    <div class="d-flex">
                        <div class="mb-1 mb-sm-0 text-muted w-50 text-left w-100">
                            <p class="mb-0"><em><a href="creaElemento.php?id=<?php echo $elemento["id"] ?>"><strong><?php echo $elemento["elementi"] ?></strong></a></em></p>
                        </div>
                    </div>
                    <div class="azioni d-flex align-items-center justify-content-end">
                        <form class="d-inline-flex mr-sm-1">
                            <div class="input-group input-group-sm d-flex align-items-center">
                                <small class="text-muted mr-2">Pos.</small>
                                <input type="number" id="nuovaPosizioneElemento<?php echo $elemento["id"]; ?>" class="form-control" aria-label="posizione" min="1" value="<?php echo $elemento["posizione"] ?>">
                                <div class="input-group-append">
                                    <button class="btn btn-primary" type="button" onclick="spostaElementoInput(<?php echo $elemento["id"]; ?>)">Salva</button>
                                </div>
                            </div>
                        </form>
                        <div class="btn-group" role="group" aria-label="Basic example">
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizionePrecedente ?>)" data-original-title="Sposta su"><i class="fas fa-arrow-up"></i></button>
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizioneSuccesiva ?>)" data-original-title="Sposta giu"><i class="fas fa-arrow-down"></i></button>
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="location.href='creaElemento.php?id=<?php echo $elemento["id"]; ?>';" data-original-title="Configura elemento"><i class="fas fa-cog"></i></button>
                            <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" onclick="eliminaElemento(<?php echo $elemento["id"]; ?>,'<?php echo $elementiEscape; ?>')" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                        </div>
                    </div>
                </div>
            <?php
            }
        }
        
        function modificaElemento($id,$elementi,$coloreSfondo,$coloreTesti) {
            $query = "UPDATE geec_righeTabella SET elementi='$elementi', coloreSfondo='$coloreSfondo', coloreTesti='$coloreTesti' WHERE id=$id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function cambiaImmagineElemento($idElemento,$percorsoFoto) {
            $query = "UPDATE `geec_righeTabella` SET  immagine ='$percorsoFoto' WHERE id=$idElemento";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        function spostaElemento($idElemento,$posizione) {
            $queryPosizione = "SELECT * FROM geec_righeTabella WHERE idTabella=$this->id AND id != $idElemento ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geec_righeTabella SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geec_righeTabella SET posizione=$posizione WHERE id = $idElemento ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function eliminaElemento($idElemento) {
            $this->db->eseguiQueryCancellazione("geec_righeTabella",$idElemento);
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getIntestazione() {
            return $this->intestazione;
        }

        public function getNote() {
            return $this->note;
        }

        public function getOrdinabile() {
            return $this->ordinabile;
        }

        public function getSfondoIntestazione() {
            return $this->sfondoIntestazione;
        }

        public function getColoreTestiIntestazione() {
            return $this->coloreTestiIntestazione;
        }

        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setNome($nome): void {
            $this->nome = $nome;
        }

        public function setSpazioOccupato($spazioOccupato): void {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setIntestazione($intestazione): void {
            $this->intestazione = $intestazione;
        }

        public function setNote($note): void {
            $this->note = $note;
        }

        public function setOrdinabile($ordinabile): void {
            $this->ordinabile = $ordinabile;
        }

        public function setSfondoIntestazione($sfondoIntestazione): void {
            $this->sfondoIntestazione = $sfondoIntestazione;
        }

        public function setColoreTestiIntestazione($coloreTestiIntestazione): void {
            $this->coloreTestiIntestazione = $coloreTestiIntestazione;
        }

    }